<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Controller\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Order extends \XLite\Controller\Admin\Order
{
    /**
     * doActionUpdate
     *
     * @return void
     */
    protected function doActionUpdate()
    {
        parent::doActionUpdate();

        if ($this->areBackorderedProductsAdded()) {
            $order = $this->getOrder();
            $order->setShippingStatus(\XLite\Model\Order\Status\Shipping::STATUS_BACK_ORDERED);
            \XLite\Core\Database::getEM()->flush();
        }
    }

    /**
     * Check if backordered products have been added to the order.
     *
     * @return boolean
     */
    protected function areBackorderedProductsAdded()
    {
        $request = \XLite\Core\Request::getInstance();

        foreach ($request->new as $key => $value) {
            if ($key != 0) {
                $product = \XLite\Core\Database::getRepo('XLite\Model\Product')->find($value['name']);
                if (
                    $product
                    && ($product->getAmount() < $value['amount'])
                    && $product->getIsAvailableForBackorder()
                ) {
                    return true;
                }
            }
        }

        return false;
    }
}
