<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use QSL\Backorder\Model\Product\ProductStockAvailabilityPolicy;

/**
 * @Extender\Mixin
 */
abstract class ModelOrderItemSelector extends \XLite\Controller\Admin\ModelOrderItemSelector
{
    /**
     * Define specific data structure which will be sent in the triggering event (model.selected)
     *
     * @param mixed $item Model item
     *
     * @return string
     */
    protected function defineDataItem($item)
    {
        $data = parent::defineDataItem($item);

        if ($this->orderItem->getProduct()->getIsAvailableForBackorder()) {
            if (! $this->orderItem->getProduct()->getIsBackorderLimit()) {
                $data['real_qty'] = $data['max_qty'];
                $data['max_qty'] = 1000;
            }

            $data[ProductStockAvailabilityPolicy::PRODUCT_IS_AVAILABLE_FOR_BACKORDER] = true;
        }

        return $data;
    }
}
