<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Controller\Admin;

class BackorderedProducts extends \XLite\Controller\Admin\AAdmin
{
    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return \XLite\Core\Request::getInstance()->page === 'products'
            ? static::t('Products')
            : static::t('Orders');
    }

    /**
     * @return void
     */
    public function handleRequest()
    {
        if (!isset(\XLite\Core\Request::getInstance()->page)) {
            $this->redirect(
                $this->buildURL(
                    'backordered_products',
                    '',
                    ['page' => 'orders']
                )
            );
        }

        parent::handleRequest();
    }
}
