<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\API\Endpoint\Product\DTO;

use ApiPlatform\Core\Annotation\ApiProperty;
use XCart\Extender\Mapping\Extender;
use XLite\API\Endpoint\Product\DTO\ProductInput as ProductInputOriginal;

/**
 * @Extender\Mixin
 */
class ProductInput extends ProductInputOriginal
{
    public bool $available_for_backorder = true;

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "example"="0"
     *         }
     *     }
     * )
     */
    public int $backorder_limit = 0;
}
