/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

decorate(
    'OrderItemsList',
    'handleProductModelSelect',
    function(event, data)
    {
        arguments.callee.previousMethod.apply(this, arguments);

        var $wrapper = jQuery(data.element).closest('.model-selector');
        var $ulselector = jQuery('.model-is-defined ul', $wrapper);

        if (data.data.is_available_for_backorder) {
            var line = jQuery(data.element).parents('tr.create-line.line').eq(0);
            line.find('td.amount input').parent().parent().append(
                '<input name="real_qty" value="' + data.data.real_qty + '" type="hidden" />'
            );

            if (data.data.real_qty < 1) {
                backorderShowOrderItemWarning($ulselector);
            }

            line.parents('form').get(0).commonController.bindElements();
        } else {
            backorderRemoveOrderItemWarning($ulselector);
        }
    }
);

decorate(
    'OrderItemsList',
    'handleItemChanged',
    function(event, data)
    {
        arguments.callee.previousMethod.apply(this, arguments);

        var line = jQuery(data.line);
        var real_qty    = parseInt(line.find('td.cell.amount input[name="real_qty"]').val());
        var current_qty = parseInt(line.find('td.cell.amount input.integer').val())
        if (!isNaN(real_qty)) {
            $ulselector = jQuery('.model-is-defined ul', line);

            if (current_qty > real_qty) {
                backorderShowOrderItemWarning($ulselector);
            } else {
                backorderRemoveOrderItemWarning($ulselector);
            }          
        }
    }
);

function backorderShowOrderItemWarning(jquery_selector) {
    if (jQuery('li.backorder-message', jquery_selector).length === 0) {
        jquery_selector.append(
            '<li class="backorder-message" style="color: red; display: list-item;">Order will be switched to Back-ordered status after saving.</li>'
        );
    }
}

function backorderRemoveOrderItemWarning(jquery_selector) {
    jQuery('li.backorder-message', jquery_selector).remove();
}