<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\BackInStock\EntityCallback;

use Doctrine\ORM\Event\PrePersistEventArgs;
use QSL\BackInStock\Model\Record;

final class RecordCallback
{
    public function prePersist(Record $recordPrice, PrePersistEventArgs $args): void
    {
        if (!$recordPrice->getDate()) {
            $recordPrice->setDate(\XLite\Core\Converter::time());
        }
    }
}
