<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\BackInStock\EntityCallback;

use Doctrine\ORM\Event\PreUpdateEventArgs;
use XLite\Model\Product;
use QSL\BackInStock\Model\Record;

final class ProductCallback
{
    public function preUpdate(Product $product, PreUpdateEventArgs $args): void
    {
        $entityManager = $args->getObjectManager();
        if ($args->hasChangedField('amount')) {
            $entityManager->getRepository(Record::class)->updateAsChanged($product);
        }

        if ($args->hasChangedField('price') && $product->getPublicAmount() > 0) {
            $entityManager->getRepository(Record::class)->updateAsChanged($product);
        }
    }
}
