/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Back to stock widget controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function Back2StockView(base) {
  this.callSupermethod('constructor', arguments);

  xcart.bind('back2stockrecordadded', _.bind(this.handleAdded, this));
  xcart.bind('back2stockrecordremoved', _.bind(this.handleRemoved, this));
}

extend(Back2StockView, ALoadable);

// No shade widget
Back2StockView.prototype.shadeWidget = true;

// Widget target
Back2StockView.prototype.widgetTarget = 'product';

// Widget class name
Back2StockView.prototype.widgetClass = '\\QSL\\BackInStock\\View\\CustomerNote';

// Form open speed
Back2StockView.prototype.openSpeed = 500;

Back2StockView.autoload = function () {
  jQuery('.back2stock-box').each(
    function () {
      if (typeof(jQuery(this).get(0).loadable) == 'undefined') {
        new Back2StockView(jQuery(this));
      }
    }
  );
};

// Postprocess widget
Back2StockView.prototype.postprocess = function (isSuccess) {
  this.callSupermethod('postprocess', arguments);

  if (isSuccess) {
    this.base.find('.remove-notification').click(_.bind(this.handleRemoveRecord, this));
  }
};

// Get additional parameters
Back2StockView.prototype.getParams = function (params) {
  var result = ALoadable.prototype.getParams.apply(this, [params]);
  result.product_id = this.base.data('product-id');
  result.variant_id = this.base.data('variant-id');

  return result;
};

// Open form handler
Back2StockView.prototype.handleOpenForm = function () {
  this.base.find('.box').show(this.openSpeed);

  return false;
};

// Save record handler
Back2StockView.prototype.handleSaveRecord = function () {
  var email = this.base.find('input[name="email"]');
  if (email.length == 0 || email.get(0).commonController.validate()) {
    xcart.post(
      this.base.data('post-url'),
      null,
      {
        'email': email.val()
      }
    );
  }
};

// Handle change email
Back2StockView.prototype.handleChangeEmail = function () {
  var email = this.base.find('input[name="email"]');
  if (email.length > 0) {
    this.base.find('button').prop('disable', !email.get(0).commonController.validate(true, true));
  }
};

// Remove record handler
Back2StockView.prototype.handleRemoveRecord = function (event) {
  xcart.post(event.currentTarget.href);

  return false;
};

Back2StockView.prototype.handleAdded = function () {
  this.load();
};

Back2StockView.prototype.handleRemoved = function () {
  this.load();
};

Back2StockView.prototype.shade = function () {
  ALoadable.prototype.shade.apply(this);

  var pattern = this.base.prop('class');
  overlayRegistry[pattern] = null;
};

// Get event namespace (prefix)
Back2StockView.prototype.getEventNamespace = function () {
  return 'bac2stock';
};

xcart.autoload(Back2StockView);

jQuery(document).ready(
  function() {

    // Popup form
    xcart.microhandlers.add(
      'notifyMePopupForm',
      'form.notify-me-form',
      function(event) {
        if (jQuery(this).parents('.popup-window-entry').length) {
          var f = this.commonController.getErrorPlace;
          this.commonController.getErrorPlace = function() {
            if (!this.errorPlace) {
              var box = f.apply(this);
              box.remove()
                .insertBefore(this.$form.find('button[type="submit"]').eq(0));
            }
            return this.errorPlace;
          };
        }
      }
    );

    // Popup form
    xcart.bind(
      'afterPopupPlace',
      function(e) {
        Back2StockView.autoload();
      }
    );

  }
);

xcart.registerTriggersBind(
  'update-product-page',
  function () {
    var container = jQuery('.back2stock-box');
    if (container.length == 0) {
      // skip processing, no widget
      return;
    }
    new Back2StockView(container);
    if (container.parents('form').get(0) && container.parents('form').get(0).commonController) {
        container.parents('form').get(0).commonController.bindElements();
    }
  }
);

xcart.registerShadowWidgets(
  'update-product-page',
  function () {
    return '.widget-fingerprint-customer-note';
  }
);
