/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Back to stock widget controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonNotifyMe(base)
{
  PopupButtonNotifyMe.superclass.constructor.apply(this, arguments);

  this.base.addClass('assigned');

  xcart.bind('back2stockrecordadded', _.bind(this.handleAdded, this));
  xcart.bind('back2stockrecordclosed', _.bind(this.handleClosed, this));
  xcart.bind('back2stockrecordremoved', _.bind(this.handleRemoved, this));

  xcart.bind('afterPopupPlace', _.bind(this.handleAfterPopupPlace, this));
}

extend(PopupButtonNotifyMe, PopupButton);

PopupButtonNotifyMe.prototype.pattern = '.popup-notify-me';

PopupButtonNotifyMe.prototype.enableBackgroundSubmit = true;

PopupButtonNotifyMe.prototype.handleAdded = function () {
  this.base.hide();
  this.handleClosed();
};

PopupButtonNotifyMe.prototype.handleClosed = function () {
  popup.close();
  $(this.pattern).each(function (idx, element) {
    delete(element.linkedDialog);
  });
};

PopupButtonNotifyMe.prototype.handleRemoved = function () {
  this.base.show();
};

PopupButtonNotifyMe.prototype.handleAfterPopupPlace = function () {
  jQuery(this.pattern).not('.assigned').each(
    function () {
      new PopupButtonNotifyMe(jQuery(this));
    }
  );
};

xcart.autoload(PopupButtonNotifyMe);

xcart.registerTriggersBind(
  'update-product-page',
  function () {
      var container = jQuery('button.popup-notify-me');
      if (container.length == 0) {
        // skip processing, no widget
        return;
      }
      new PopupButtonNotifyMe(container);
      if (container.parents('form').get(0) && container.parents('form').get(0).commonController) {
          container.parents('form').get(0).commonController.bindElements();
      }
  }
);

xcart.registerShadowWidgets(
  'update-product-page',
  function () {
      return '.widget-fingerprint-notify-my';
  }
);
