<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\AuthorizenetAcceptjs\View\Checkout;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Payment extends \XLite\View\Checkout\Payment
{
    /**
     * @inheritdoc
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();
        $list[] = 'modules/QSL/AuthorizenetAcceptjs/payment.css';
        $list = array_merge($list, $this->getWidget([], 'QSL\AuthorizenetAcceptjs\View\CreditCard')->getCSSFiles());

        return $list;
    }

    /**
     * @inheritdoc
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        /** @var \XLite\Model\Payment\Method $method */
        $method = \XLite\Core\Database::getRepo('XLite\Model\Payment\Method')->findByServiceName('AuthorizenetAcceptjs');

        if ($method && $method->isEnabled()) {
            $list[] = 'modules/QSL/AuthorizenetAcceptjs/payment.js';
            if ($method->getSetting('mode') == 'test') {
                $list[] = [
                    'url' => 'https://jstest.authorize.net/v1/Accept.js',
                ];
            } else {
                $list[] = [
                    'url' => 'https://js.authorize.net/v1/Accept.js',
                ];
            }
            $list = array_merge($list, $this->getWidget([], 'QSL\AuthorizenetAcceptjs\View\CreditCard')->getJSFiles());
        }

        return $list;
    }
}
