/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonRemindSelectedButton()
{
  PopupButtonRemindSelectedButton.superclass.constructor.apply(this, arguments);
}

extend(PopupButtonRemindSelectedButton, PopupButton);

PopupButtonRemindSelectedButton.prototype.pattern = '.remind-selected-button';

PopupButtonRemindSelectedButton.prototype.enableBackgroundSubmit = false;

/*
 * Copy data (IDs of selected items) prepared in
 * View\Button\RemindSelectedButton::prepareURLParams()
 * to the data to be sent to the server on the form submit.
 */
decorate(
  'PopupButtonRemindSelectedButton',
  'getURLParams',
  function (button)
  {
    var urlParams = arguments.callee.previousMethod.apply(this, arguments);

    jQuery('[name*="select"]:checked').each(function (index, elem) {urlParams[elem.name] = 1});

    return urlParams;
  }
);

/*
 * Drop the popup that was opened the last time (if any).
 */
decorate(
    'PopupButtonRemindSelectedButton',
    'eachClick',
    function (elem)
    {
      if (elem.linkedDialog) {
        jQuery(elem.linkedDialog).dialog('close').remove();
        elem.linkedDialog = undefined;
      }

      return arguments.callee.previousMethod.apply(this, arguments);
    }
);

xcart.autoload(PopupButtonRemindSelectedButton);
