/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

checkDiscountAmount = (function (){

    "use strict";

    var checkRegex = /^(\d+\.?\d*)(%?)$/,
        matchRegex = /^(\d+\.?\d*) *(%?)$/;

    CommonForm.elementControllers.push(
        {
            pattern: '.input-field-wrapper input.discount',

            handler: function () {

                this.sanitizeValue = function (value, input) {

                    var field = input ? input : jQuery(this),
                        e = field.data('e'),
                        dDelim = field.data('decimal-delim'),
                        tDelim = field.data('thousand-delim'),
                        pow = Math.pow(10, e),
                        matches = jQuery.trim(value).match(matchRegex),
                        amount,
                        percent;

                    if (matches) {
                        percent = matches[2];
                        amount = xcart.stringToNumber(matches[1], dDelim, tDelim);

                        if (('undefined' == typeof(e)) || percent) {
                            amount = parseFloat(amount);
                            if (isNaN(amount)) {
                                amount = 0;
                            }
                        } else {
                            amount = Math.round(amount * pow) / pow;
                        }
                        value = amount + percent;
                    } else {
                        value = '';
                    }

                    return value;
                };

                this.commonController.isEqualValues = function (oldValue, newValue, element) {
                    return this.element.sanitizeValue(oldValue, element) == this.element.sanitizeValue(newValue, element);
                };
            }
        }
    );

    return function (field, rules, i, options) {
        var value = jQuery.trim(field.val());
        var matches = value.match(checkRegex);
        if (!matches || (matches[2]=='%' && (matches[1]>100)))
        {
            return field.data('invalid-message');
        }
    };

}());

