/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(

  (function () {
    "use strict";

    var checkRegex = /^(\d+\.?\d*)(%?)$/,
        typeRegex = /^.*%$/;

    return {

      pattern: '.inline-field.inline-discount',

      handler: function () {

        var field = jQuery(this),
          input = jQuery('.field :input', this).eq(0),
          viewValue = field.find('.view .value'),
          viewSymbol = field.find('.view .symbol'),
          lastValue = input.val();

        this.checkValue = function (value)
        {
          return !value || checkRegex.test(jQuery.trim(value));
        };

        this.sanitize = function ()
        {
          var value = input.val();

          if (!this.checkValue(value)) {
            value = lastValue;
          }

          if (input.length) {
            input.val(input.get(0).sanitizeValue(value, input));
          }
        };

        this.getFieldFormattedValue = function ()
        {
          var value = input.val();

          return (value.indexOf('%') >= 0)
            ? value
            : xcart.numberToString(
              value,
              input.data('decimal-delim'),
              input.data('thousand-delim'),
              input.data('e')
            );
        };

        // Save field into view
        this.saveField = function()
        {
          var value = this.getFieldFormattedValue();

          viewValue.html(htmlspecialchars("" == value ? " " : value, null, null, false));

          if (typeRegex.test(value) || !value) {
            viewSymbol.hide();
          } else {
            viewSymbol.show();
          }
        };

        this.saveField();
      }

    };

  }())

);
