/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Switcher highligh row controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(
  {
    pattern: '.input-field-wrapper.switcher',
    handler: function () {
      var input = jQuery(':checkbox', this);
      var cell = jQuery(this).parents('.line').eq(0);
      
      input.change(
        function () {
          if (this.checked) {
            cell.addClass('enabled-mark');
            cell.removeClass('disabled-mark');
          } else {
            cell.removeClass('enabled-mark');
            cell.addClass('disabled-mark');
          }
        }
      );
      
      input.change();

      jQuery(this).popover({
        placement: 'top'
      })
      .on("mouseenter", function() {
        let content = $(this).data("tooltip").replace("STATUS", input.prop("checked") ? 'Enabled' : 'Disabled');
        $(this).popover().attr("data-content", content);
        $(this).popover("show");
      })
      .on("mouseleave", function() {
        $(this).popover("hide");
      });
    }    
  }         
);