/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Switcher highligh row controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function () {

  var checkZero = /^0+\.?0*%?$/;

  CommonForm.elementControllers.push(
    {
      pattern: '.coupon .reminder-coupon',

        handler: function () {
          var input = jQuery('input', this);
          var cell = jQuery(this).parents('.line').eq(0);

          input.change(
            function () {
              var value = jQuery.trim(this.value);
              if (('' === value) || checkZero.test(value)) {
                cell.removeClass('has-coupon-mark');
                cell.addClass('no-coupon-mark');
              } else {
                cell.addClass('has-coupon-mark');
                cell.removeClass('no-coupon-mark');
              }
            }
          );

          input.change();
        }
      }
  );

}());
