<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\AMP\View\Menu\Customer;

use XCart\Domain\ModuleManagerDomain;
use XCart\Extender\Mapping\ListChild;

/**
 * Primary menu
 *
 * @ListChild (list="amp.header.menu", weight="10")
 */
class Top extends \XLite\View\Menu\Customer\Top
{
    protected ?ModuleManagerDomain $moduleManagerDomain;

    public function __construct(array $params = [])
    {
        $this->moduleManagerDomain = \XCart\Container::getContainer()?->get(ModuleManagerDomain::class);

        parent::__construct($params);
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/QSL/AMP/modules/CDev/SimpleCMS/primary_menu_items.twig';
    }

    /**
     * Check if widget is visible
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return $this->moduleManagerDomain->isEnabled('CDev-SimpleCMS');
    }
}
