<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\AMP\Core;

use Symfony\Contracts\HttpClient\Exception\TransportExceptionInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

/**
 * Methods to update AMP cache
 */
class CacheUpdater
{
    public const ENDPOINT = 'https://cdn.ampproject.org/update-ping/c/';

    protected HttpClientInterface $client;

    public function __construct(HttpClientInterface $client)
    {
        $this->client = $client;
    }

    /**
     * Update Google AMP Cache
     *
     * @param $url
     *
     * @return bool
     */
    public function updateUrl($url)
    {
        $https = preg_match('/^https:/', $url);

        $url = substr($url, strlen($https ? 'https://' : 'http://'));

        $apiUrl = self::ENDPOINT . ($https ? 's/' : '') . $url;

        return $this->getStatusCodeAfterSendRequest($apiUrl) === 204;
    }

    protected function getStatusCodeAfterSendRequest(string $apiUrl): ?int
    {
        $statusCode = null;

        try {
            $response = $this->client->request(
                'GET',
                $apiUrl
            );
            $statusCode = $response->getStatusCode();
        } catch (TransportExceptionInterface) {
        }

        return $statusCode;
    }
}
