<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\XMLSitemap\Model\Repo;

use JetBrains\PhpStorm\Deprecated;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Product extends \XLite\Model\Repo\Product
{
    /**
     * @param int $position Position @deprecated since CDev-XMLSitemap 5.5.1.2
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineSitemapGenerationQueryBuilder(#[Deprecated] $position = null)
    {
        $qb = parent::defineSitemapGenerationQueryBuilder($position);

        $qb->select($qb->getMainAlias() . '.product_id')
            ->andWhere($qb->getMainAlias() . '.enabled = :enabled')
            ->setParameter('enabled', true);

        return $qb;
    }

    /**
     * Count products as sitemaps links
     *
     * @return integer
     */
    public function countProductsAsSitemapsLinks()
    {
        return $this->defineProductsAsSitemapsLinksQuery()->count();
    }

    /**
     * Find one product as sitemap link
     *
     * @param integer $position Position
     *
     * @return \XLite\Model\Product
     */
    public function findOneAsSitemapLink($position)
    {
        return $this->defineProductsAsSitemapsLinksQuery()
            ->setMaxResults(1)
            ->setFirstResult($position)
            ->getSingleResult();
    }

    /**
     * Find one product as sitemap link
     *
     * @param integer $position Position
     *
     * @return \XLite\Model\Product
     */
    public function findAsSitemapLink($position, $count = 1)
    {
        return $this->defineProductsAsSitemapsLinksQuery()
            ->setMaxResults($count)
            ->setFirstResult($position)
            ->getResult();
    }

    /**
     * Define specific query to find out products links for sitemap
     *
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function defineProductsAsSitemapsLinksQuery()
    {
        return $this->createPureQueryBuilder()
            ->andWhere('p.enabled = :enabled')
            ->setParameter('enabled', 1);
    }
}
