<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\XMLSitemap\Model\Repo;

use JetBrains\PhpStorm\Deprecated;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Category extends \XLite\Model\Repo\Category
{
    /**
     * @param int $position Position @deprecated since CDev-XMLSitemap 5.5.1.2
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineSitemapGenerationQueryBuilder(#[Deprecated] $position = null)
    {
        $qb = parent::defineSitemapGenerationQueryBuilder($position);

        $qb->select($qb->getMainAlias() . '.category_id')
            ->andWhere($qb->getMainAlias() . '.parent IS NOT NULL');

        $this->addCleanURLCondition($qb);

        return $qb;
    }

    /**
     * Add clean url if applicable
     *
     * @param \XLite\Model\QueryBuilder\AQueryBuilder $qb
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function addCleanURLCondition(\XLite\Model\QueryBuilder\AQueryBuilder $qb)
    {
        if (\CDev\XMLSitemap\Logic\Sitemap\Step\Categories::isSitemapCleanUrlConditionApplicable()) {
            $joinCnd = 'cu.id = (SELECT MAX(cu2.id) FROM XLite\Model\CleanURL cu2 WHERE cu2.category = ' . $qb->getMainAlias() . ')';
            $qb->addSelect('cu.cleanURL')
                ->leftJoin('XLite\Model\CleanURL', 'cu', \Doctrine\ORM\Query\Expr\Join::WITH, $joinCnd);
        }

        return $qb;
    }

    /**
     * Count categories as sitemaps links
     *
     * @return integer
     */
    public function countCategoriesAsSitemapsLinks()
    {
        return $this->defineCountQuery()->andWhere('c.parent IS NOT NULL')->count();
    }

    /**
     * Find one as sitemap link
     *
     * @param integer $position Position
     *
     * @return \XLite\Model\Category
     */
    public function findOneAsSitemapLink($position)
    {
        return $this->createPureQueryBuilder()
            ->andWhere('c.parent IS NOT NULL')
            ->setMaxResults(1)
            ->setFirstResult($position)
            ->getSingleResult();
    }
}
