<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\XMLSitemap\Model\Repo;

use JetBrains\PhpStorm\Deprecated;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class ARepo extends \XLite\Model\Repo\ARepo
{
    /**
     * @param int $position Position OPTIONAL
     *
     * @return iterable
     */
    public function getSitemapGenerationIterator($position = 0)
    {
        return $this->defineSitemapGenerationQueryBuilder()
            ->setFirstResult($position)
            ->setMaxResults(\CDev\XMLSitemap\Core\EventListener\SitemapGeneration::CHUNK_LENGTH)
            ->iterate();
    }

    /**
     * @param int $position Position @deprecated since CDev-XMLSitemap 5.5.1.2
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineSitemapGenerationQueryBuilder(#[Deprecated] $position = null)
    {
        if ($position !== null) {
            trigger_deprecation('CDev-XMLSitemap', '5.5.1.2', 'Calling "%s" with argument $position is deprecated.', __METHOD__);
        }

        return $this->createPureQueryBuilder();
    }

    /**
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineCountForSitemapGenerationQuery()
    {
        $qb = $this->defineSitemapGenerationQueryBuilder();

        return $qb->select(
            'COUNT(DISTINCT ' . $qb->getMainAlias() . '.' . $this->getPrimaryKeyField() . ')'
        );
    }

    /**
     * @return int
     */
    public function countForSitemapGeneration()
    {
        return (int) $this->defineCountForSitemapGenerationQuery()->getQuery()->getSingleScalarResult();
    }
}
