<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\Wholesale\Transformer\CDev\Wholesale\Model\WholesalePrice\Logic\Entity\Storefront;

use XCart\Factory\Logic\Entity\Storefront\WholesalePriceInterface as Factory;
use CDev\Wholesale\Model\WholesalePrice as WholesalePriceModel;
use CDev\Wholesale\Module\XC\ProductVariants\Model\ProductVariantWholesalePrice as ProductVariantWholesalePriceModel;
use XCart\Logic\Entity\Storefront\WholesalePrice as Target;

class WholesalePrice implements WholesalePriceInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(WholesalePriceModel|ProductVariantWholesalePriceModel $input): Target
    {
        $target = $this->factory->create();

        $target
            ->setType($input->getType())
            ->setQuantityRangeBegin($input->getQuantityRangeBegin())
            ->setQuantityRangeEnd($input->getQuantityRangeEnd() ?: null)
            ->setValue($input->getPrice());

        return $target;
    }
}
