<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Wholesale\Logic\Action\Storefront\Product\GetOne;

use CDev\Wholesale\Model\WholesalePrice as WholesalePriceModel;
use CDev\Wholesale\Transformer\CDev\Wholesale\Model\WholesalePrice\Logic\Entity\Storefront\WholesalePriceInterface as WholesalePriceTransformer;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\Assembler\QueryBuilder\FindOneQueryBuilderAssemblerInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\DTO\Response as GetOneProductResponse;
use XCart\Logic\Entity\Storefront\Product as ProductLogicDto;

class ActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private FindOneQueryBuilderAssemblerInterface $queryBuilderAssembler,
        private WholesalePriceTransformer $wholesalePriceTransformer,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);

        if ($response instanceof GetOneProductResponse) {
            /** @var ProductLogicDto $payload */
            $payload = $response->getPayload();

            $qb           = $this->queryBuilderAssembler->assemble($request);
            $productModel = $qb->getQuery()->getOneOrNullResult();

            $productModel->setWholesaleMembership(
                $request->getProfile()?->getMembership()
            );

            $payload->setMinPurchaseQuantity(
                $productModel->getMinQuantityForCurrentMembership()
            );

            $payload->setApplySaleToWholesale(
                $productModel->getApplySaleToWholesale()
            );

            if ($productModel->isWholesalePricesEnabled()) {
                $wholesalePrices = array_map(
                    function (WholesalePriceModel $wholesalePrice) {
                        return $this->wholesalePriceTransformer->transform($wholesalePrice);
                    },
                    $productModel->getPreparedWholesalePricesForCurrentMembership()
                );

                $payload->setWholesalePrices($wholesalePrices);
            }
        }

        return $response;
    }
}
