<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\View\FormField\Select;

/**
 * First class mail type selector for settings page
 */
class FirstClassMailType extends \XLite\View\FormField\Select\Regular
{
    /**
     * Get default options for selector
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return [
            'LETTER'          => static::t('Letter'),
            'LARGE ENVELOPE'  => static::t('Large Envelope'),
            'PARCEL'          => static::t('Parcel'),
            'POSTCARD'        => static::t('Postcard'),
            'LARGE POSTCARD'  => static::t('Large Postcard'),
            'PACKAGE SERVICE' => static::t('Package service'),
        ];
    }
}
