<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\View\FormField\Select;

/**
 * Container selector for settings page
 */
class Container extends \XLite\View\FormField\Select\Regular
{
    /**
     * Get default options for selector
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return [
            'VARIABLE'                     => static::t('Variable'),
            'FLAT RATE ENVELOPE'           => static::t('Flat rate envelope'),
            'PADDED FLAT RATE ENVELOPE'    => static::t('Padded flat rate envelope'),
            'LEGAL FLAT RATE ENVELOPE'     => static::t('Legal flat rate envelope'),
            'SM FLAT RATE ENVELOPE'        => static::t('SM flat rate envelope'),
            'WINDOW FLAT RATE ENVELOPE'    => static::t('Window flat rate envelope'),
            'GIFT CARD FLAT RATE ENVELOPE' => static::t('Gift card flat rate envelope'),
            'FLAT RATE BOX'                => static::t('Flat rate box'),
            'SM FLAT RATE BOX'             => static::t('SM flat rate box'),
            'MD FLAT RATE BOX'             => static::t('MD flat rate box'),
            'LG FLAT RATE BOX'             => static::t('LG flat rate box'),
            'REGIONALRATEBOXA'             => static::t('Regional rate boxA'),
            'REGIONALRATEBOXB'             => static::t('Regional rate boxB'),
        ];
    }
}
