<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\Model;

use CDev\USPS\View\Model\Settings;
use XCart\Extender\Mapping\Extender;
use CDev\USPS\Model\Shipping\Processor\USPS;
use XLite\Model\Shipping\Processor\AProcessor;

/**
 * @Extender\Mixin
 */
class Shipping extends \XLite\Model\Shipping
{
    /**
     * @param string $processorId
     *
     * @return null|AProcessor
     */
    public static function getProcessorObjectByProcessorId($processorId)
    {
        if ($processorId === Settings::USPS_PROCESSOR_ID) {
            $result = null;

            $processors = \XLite\Model\Shipping::getInstance()->getProcessors();
            foreach ($processors as $obj) {
                if ($obj instanceof USPS) {
                    $result = $obj;
                    break;
                }
            }

            return $result;
        } else {
            return parent::getProcessorObjectByProcessorId($processorId);
        }
    }
}
