<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\Model\Payment\Processor;

use XLite\Model\Payment\Method;

/**
 * 'Cash on Delivery' payment method class
 */
class COD extends \XLite\Model\Payment\Processor\COD
{
    /**
     * Shipping method carrier code which is allowed to make COD payment method available at checkout
     *
     * @var string
     */
    protected $carrierCode = 'usps';

    /**
     * Get payment method admin zone icon URL
     *
     * @param Method $method Payment method
     *
     * @return string
     */
    public function getAdminIconURL(Method $method)
    {
        return true;
    }
}
