<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS;

use XLite\Core\Converter;
use XLite\Module\AModule;

abstract class Main extends AModule
{
    /**
     * Return link to settings form
     *
     * @return string
     */
    public static function getSettingsForm()
    {
        return Converter::buildURL('usps');
    }

    /**
     * Return true if module should work in strict mode
     * (strict mode enables the logging of errors like 'The module is not configured')
     *
     * @return boolean
     */
    public static function isStrictMode()
    {
        return false;
    }

    /**
     * @return string
     */
    public static function getUrlLive(): string
    {
        return 'https://production.shippingapis.com/ShippingAPI.dll';
    }

    /**
     * @return string
     */
    public static function getUrlTest(): string
    {
        return 'https://stg-secure.shippingapis.com/ShippingApi.dll';
    }
}
