<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\LifetimeHook\Upgrade;

use CDev\USPS\View\Model\Settings;
use XCart\Doctrine\FixtureLoader;
use XLite\Core\Config;
use XLite\Core\Database;
use XLite\Model\Shipping\Method;

class UpgradeTo551build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'CDev/USPS/resources/hooks/upgrade/5.5/1.0/upgrade.yaml');

        $entityManager = Database::getEM();

        if (Config::getInstance()->CDev->USPS->dataProvider === 'pitneyBowes') {
            $shippingMethods = Database::getRepo(Method::class)?->findBy([
                'processor' => Settings::USPS_PROCESSOR_ID,
            ]);
            /** @var Method $method */
            foreach ($shippingMethods as $method) {
                $method->setEnabled(false);
            }
            $entityManager->flush();
        }

        $pbShippingMethods = Database::getRepo(Method::class)?->findBy([
            'processor' => Settings::USPS_PROCESSOR_ID,
            'carrier' => 'pb_usps'
        ]);

        $pbOptions = Database::getRepo(\XLite\Model\Config::class)?->findBy([
            'name' => [
                'pbEmailId',
                'pbShipperId',
                'pb_domestic_parcel_type',
                'pb_international_parcel_type',
                'pbSandbox',
                'dataProvider',
            ],
            'category' => 'CDev\USPS',
        ]);

        foreach (array_merge($pbOptions, $pbShippingMethods) as $entity) {
            $entityManager->remove($entity);
        }
        $entityManager->flush();
    }
}
