<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\LifetimeHook\Upgrade;

use CDev\USPS\Main;
use XCart\Doctrine\FixtureLoader;

class UpgradeTo550build3
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'CDev/USPS/resources/hooks/upgrade/5.5/0.3/upgrade.yaml');

        $isLiveMode = false;

        if (
            !empty(\XLite\Core\Config::getInstance()->CDev->USPS->server_url)
            && \XLite\Core\Config::getInstance()->CDev->USPS->server_url === Main::getUrlLive()
        ) {
            $isLiveMode = true;
        }

        if ($isLiveMode) {
            /** @var \XLite\Model\Config $testMode */
            $testMode = \XLite\Core\Database::getRepo(\XLite\Model\Config::class)
                ?->findBy(['name' => 'CDev\USPS', 'category' => 'test_mode']);

            if ($testMode) {
                \XLite\Core\Database::getRepo(\XLite\Model\Config::class)?->update(
                    $testMode,
                    ['value' => false]
                );
            }
        }

        /** @var \XLite\Model\Config $serverUrl */
        $serverUrl = \XLite\Core\Database::getRepo(\XLite\Model\Config::class)
            ?->findBy(['name' => 'CDev\USPS', 'category' => 'server_url']);

        if ($serverUrl) {
            \XLite\Core\Database::getEM()->remove($serverUrl);
        }

        \XLite\Core\Database::getEM()->flush();
    }
}
