<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\USPS\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;
use XLite\Model\OrderTrackingNumber;

/**
 * @Extender\Mixin
 */
class Order extends \XLite\Controller\Admin\Order
{
    /**
     * @param string $value
     *
     * @return OrderTrackingNumber
     */
    protected function getTrackingNumberByValue($value)
    {
        foreach ($this->getOrder()->getTrackingNumbers() as $trackingNumber) {
            if ($trackingNumber->getValue() === $value) {
                return $trackingNumber;
            }
        }

        return null;
    }

    /**
     * @param string $value
     */
    protected function addTrackingNumber($value)
    {
        $trackingNumber = $this->getTrackingNumberByValue($value);

        if ($trackingNumber === null) {
            $trackingNumber = new OrderTrackingNumber();
            $trackingNumber->setOrder($this->getOrder());
            $trackingNumber->setValue($value);

            Database::getEM()->persist($trackingNumber);
        }
    }

    /**
     * @param string $value
     */
    protected function removeTrackingNumber($value)
    {
        $trackingNumber = $this->getTrackingNumberByValue($value);

        if ($trackingNumber !== null) {
            $this->getOrder()->getTrackingNumbers()->removeElement($trackingNumber);
            Database::getEM()->remove($trackingNumber);
        }
    }

    /**
     * Check the shipping inside the country
     *
     * @param \XLite\Model\Order $order
     * @return bool
     */
    protected function isLocalShipping(\XLite\Model\Order $order)
    {
        $profile = $order->getProfile();

        $dstAddr = $profile->getShippingAddress()->getCountryCode();
        $srcAddr = $order->getSourceAddress()->getCountryCode();

        return $dstAddr === $srcAddr;
    }
}
