<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\View\FormField\Select;

use CDev\SimpleCMS\Model\Page as PageModel;
use CDev\SimpleCMS\Model\Repo\Page as PageRepo;
use XLite\Core\Converter;
use XLite\Core\CommonCell;
use XLite\Core\Database;

class ContentPagesSelect extends \XLite\View\FormField\Select\Regular
{
    /**
     * @return array
     */
    protected function getDefaultOptions()
    {
        $contentPageUrls = $this->getContentPageUrls();

        return $this->prepareContentPages($contentPageUrls);
    }

    protected function getContentPageUrls(): ?array
    {
        $cnd = new CommonCell([
            'type' => [
                PageModel::TYPE_DEFAULT,
                PageModel::TYPE_SERVICE,
            ]
        ]);
        return $this->getPageRepo()->search($cnd);
    }

    protected function prepareContentPages(?array $contentPageUrls): array
    {
        $result = [];
        if ($contentPageUrls) {
            foreach ($contentPageUrls as $page) {
                $result[$this->getPageURL($page)] = static::t($page->getName());
            }
        }

        return $result;
    }

    protected function getPageURL(PageModel $page): string
    {
        return $page->getCleanURLbyFrontURL()
            ?: $page->getFrontUrl()
            ?: Converter::buildCleanURL('page', null, ['id' => $page->getId()])
            ?: Converter::buildURL('page', null, ['id' => $page->getId()], '');
    }

    protected function getPageRepo(): PageRepo
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return Database::getRepo(PageModel::class);
    }
}
