<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\View\FormField\Input;

use XLite\Core\Skin;
use XLite\Model\Base\Image;

/**
 * Logo for notification emails.
 */
class NotificationLogo extends AImage
{
    /**
     * @return array{0: int, 1: int}|null
     */
    protected function getLogoSizes(): ?array
    {
        return Skin::getInstance()->getCurrentNotificationLogoImagesSettings();
    }

    /**
     * Set widget params
     *
     * @param array $params Handler params
     */
    public function setWidgetParams(array $params): void
    {
        parent::setWidgetParams($params);

        $logoSettings = $this->getLogoSizes();

        if ($logoSettings) {
            $this->widgetParams[static::PARAM_HELP]->setValue(static::t(
                'Current logo sizes: XхY px',
                [
                    'X' => $logoSettings[0],
                    'Y' => $logoSettings[1]
                ]
            ));
        }
    }

    protected function isViaUrlAllowed(): bool
    {
        return false;
    }

    protected function getAdditionalAttributes(): string
    {
        $logoSizes = $this->getLogoSizes();
        $result = parent::getAdditionalAttributes();

        if ($logoSizes) {
            $result .= (empty($result) ? '' : ' ') . 'data-logo-width="' . ($logoSizes[0] * Image::RETINA_RATIO) . '"'
                . ' data-logo-height="' . ($logoSizes[1] * Image::RETINA_RATIO) . '"';
        }

        return $result;
    }

    protected function getFieldLabelTemplate(): string
    {
        return 'form_field/label/logo_label.twig';
    }
}
