<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\View\FormField\Input;

use XLite\Model\Base\Image;
use XLite\Model\WidgetParam\TypeBool;

/**
 * Image
 *
 */
abstract class AImage extends \XLite\View\FormField\Input\AInput
{
    protected const PARAM_IS_SVG_ALLOWED = 'isSvgAllowed';

    protected const PARAM_IS_WEBP_ALLOWED = 'webp';

    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_IS_SVG_ALLOWED  => new TypeBool('Is SVG upload allowed', false),
            static::PARAM_IS_WEBP_ALLOWED => new TypeBool('Is WebP upload allowed', false)
        ];
    }

    /**
     * Return field type
     *
     * @return string
     */
    public function getFieldType()
    {
        return 'file';
    }

    /**
     * Return the image URL value
     *
     * @return \XLite\Model\Image\Common\Logo
     */
    protected function getImage()
    {
        $image = null;

        $func = 'get' . $this->getClassName();
        $logoRepo = \XLite\Core\Database::getRepo('XLite\Model\Image\Common\Logo');
        if (method_exists($logoRepo, $func)) {
            $image = $logoRepo->$func();
        }

        return $image;
    }

    /**
     * @return boolean
     */
    protected function isViaUrlAllowed()
    {
        return true;
    }


    /**
     * Return the field name for widget.
     *
     * @return string
     */
    protected function getImageName()
    {
        return lcfirst($this->getClassName());
    }

    /**
     * @return boolean
     */
    protected function isRemovable()
    {
        return \XLite\Core\Config::getInstance()->CDev->SimpleCMS->{lcfirst($this->getClassName())}
            ? true
            : false;
    }

    /**
     * @return boolean
     */
    protected function showDimensionsLink()
    {
        return false;
    }

    /**
     * Return field template
     *
     * @return string
     */
    protected function getFieldTemplate()
    {
        return '/form_field/image.twig';
    }

    /**
     * getDir
     *
     * @return string
     */
    protected function getDir()
    {
        return 'modules/CDev/SimpleCMS';
    }

    /**
     * @return boolean
     */
    protected function hasAlt()
    {
        return false;
    }

    /**
     * Return class name
     *
     * @return string
     */
    private function getClassName()
    {
        return (new \ReflectionClass($this))->getShortName();
    }

    /**
     * @return string
     */
    protected function allowExtendedTypes()
    {
        return false;
    }

    protected function isSvgAllowed(): bool
    {
        return (bool)$this->getParam(static::PARAM_IS_SVG_ALLOWED);
    }

    protected function getAdditionalAttributes(): string
    {
        return '';
    }

    protected function getAccept(): string
    {
        $isSvgAllowed = $this->isSvgAllowed();

        $extensions = [];
        if ($images = $this->getImage()) {
            $extensions = array_filter(
                $images::getAllowedExtensions(),
                static fn (string $ext): bool => ($isSvgAllowed || $ext !== Image::SVG_EXTENSION)
            );
        }

        return implode(
            ', ',
            array_map(
                static fn (string $ext): string => ".{$ext}",
                $extensions
            )
        );
    }
}
