<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\SimpleCMS\Transformer\CDev\SimpleCMS\Model\Page\Logic\Entity\Storefront;

use CDev\SimpleCMS\Model\Page as Source;
use XCart\Logic\Entity\Storefront\StaticPage as Target;
use CDev\SimpleCMS\Model\Image\Page\Image as ImagePage;
use XCart\Factory\Logic\Entity\Storefront\ImageInterface as ImageFactory;
use XCart\Transformer\CDev\SimpleCMS\Model\Page\Logic\Entity\Storefront\StaticPageInterface;

class StaticPageDecorator implements StaticPageInterface
{
    public function __construct(
        private StaticPageInterface $inner,
        private ImageFactory $imageFactory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input)
            ->setName($input->getName())
            ->setBody($input->getBody())
            ->setMetaKeywords($input->getMetaKeywords())
            ->setMetaTitle($input->getMetaTitle())
            ->setMetaDescription($input->getTeaser())
            ->setCleanUrl($input->getCleanURL());

        if ($image = $input->getImage()) {
            $target->setImage($this->prepareImage($image));
        }

        return $target;
    }

    private function prepareImage(ImagePage $image): \XCart\Logic\Entity\Storefront\Image
    {
        $imageDto = $this->imageFactory->create();
        $imageDto->setUrl($image->getURL());
        $imageDto->setAlt($image->getAlt());
        $imageDto->setHeight($image->getHeight());
        $imageDto->setWidth($image->getWidth());

        return $imageDto;
    }
}
