<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\SimpleCMS\Transformer\CDev\SimpleCMS\Model\Menu\Logic\Entity\Storefront;

use Symfony\Component\Security\Core\Security;
use CDev\SimpleCMS\Model\Menu as Source;
use XCart\Logic\Entity\Storefront\Menu as Target;
use XCart\Transformer\CDev\SimpleCMS\Model\Menu\Logic\Entity\Storefront\MenuInterface;

class MenuDecorator implements MenuInterface
{
    public function __construct(
        private MenuInterface $inner,
        private Security $security,
    ) {
    }

    public function transform(Source $input): Target
    {
        $submenuCount = $input->getSubmenus()->filter(function (\CDev\SimpleCMS\Model\Menu $submenu) {
            return $submenu->getEnabled()
                && ($submenu->getVisibleFor() === 'AL' || ($this->security->getUser()?->getWrappedProfile()
                    ? $submenu->getVisibleFor() === 'L'
                    : $submenu->getVisibleFor() === 'A')
                );
        })->count();

        return $this->inner->transform($input)
            ->setName($input->getName())
            ->setParentId($input->getParentId())
            ->setSubmenuCount($submenuCount);
    }
}
