<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\Storage;

use XLite\Core\Config;
use XLite\Core\Database;
use XLite\Model\Config as ConfigModel;
use XLite\Model\Repo\Config as ConfigRepo;

class ConfigTermUrlStorage
{
    public const CONFIG_TERM_URL_NAME        = 'terms_url';
    public const CONFIG_SOURCE_TERM_URL_TYPE = 'source_type_term_url';

    public const SELECT_TERM_URL_TYPE = 'CDev\SimpleCMS\View\FormField\Select\ContentPagesSelect';

    public function setSelectTermUrlType(): void
    {
        $configTermUrl = $this->getConfigTermUrl();

        if ($configTermUrl && $configTermUrl->getType() !== self::SELECT_TERM_URL_TYPE) {
            $option = $this->getConfigRepo()->createOption(
                [
                    'category' => 'CDev\SimpleCMS',
                    'name'     => self::CONFIG_SOURCE_TERM_URL_TYPE,
                    'value'    => $configTermUrl->getType(),
                    'type'     => 'hidden',
                ],
                true
            );
            $configTermUrl->setType(self::SELECT_TERM_URL_TYPE);

            Database::getEM()->flush();
            if (!$option) {
                $option = $this->getConfigRepo()->findOneBy(['category' => 'CDev\SimpleCMS', 'name' => self::CONFIG_SOURCE_TERM_URL_TYPE]);
            }
            $this->getConfigRepo()->updateOptionInCache($option);
            $this->getConfigRepo()->updateOptionInCache($configTermUrl);
        }
    }

    public function setSourceTermUrlType(): void
    {
        $configTermUrl = $this->getConfigTermUrl();
        if ($configTermUrl) {
            $configTermUrl->setType(Config::getInstance()->CDev->SimpleCMS->{self::CONFIG_SOURCE_TERM_URL_TYPE});
            Database::getEM()->flush();
            $this->getConfigRepo()->updateOptionInCache($configTermUrl);
        }
    }

    protected function getConfigTermUrl(): ?ConfigModel
    {
        return $this->getConfigRepo()->findOneBy([
            'name'     => self::CONFIG_TERM_URL_NAME,
            'category' => 'General'
        ]);
    }

    protected function getConfigRepo(): ConfigRepo
    {
        return Database::getRepo(ConfigModel::class);
    }
}
