<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\Action\Storefront\Menu\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use Throwable;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use CDev\SimpleCMS\Model\Menu;

class Action implements ActionInterface
{
    public function __construct(
        private ReadRepositoryInterface $readRepository,
        private EntityIdAssemblerInterface $entityIdAssembler,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $id = $this->entityIdAssembler->assemble($request);

        try {
            $entities = $this->readRepository->createEmptyQueryBuilder()
                ->select('m')
                ->from(Menu::class, 'm')
                ->where('m.id = :id')->setParameter('id', $id)
                ->andWhere('m.enabled = 1')
                ->andWhere('m.visibleFor IN (:visibleFor)')
                ->setParameter('visibleFor', $request->getProfile() ? ["AL", "L"] : ["AL", "A"])
                ->setMaxResults(1)
                ->getQuery()
                ->getResult();
        } catch (Throwable $e) {
            return (new DefaultFailedResponse())
                ->setType('Internal error')
                ->setTitle(sprintf('Cannot read entity from DB: %s', $e))
                ->setStatus(HTTPResponse::HTTP_INTERNAL_SERVER_ERROR);
        }

        if (!$entities) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entity')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->responseAssembler->assemble($entities[0]);
    }
}
