<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\Action\Storefront\Menu\Assembler\Criteria;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Criteria\FindListCriteriaAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\IntegerValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\StringListValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\StringValue;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\BooleanFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\ListFilterStrategyType;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\NumberFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\StringFilterStrategyType;
use XCart\DTO\Doctrine\Storefront\Menu\Filter;
use XCart\Logic\DTO\Request\ProfileOwnerRequestInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enum\OrderRuleDirection;
use XCart\DTO\Doctrine\Storefront\Menu\OrderRule;

class FindListCriteriaAssemblerDecorator implements FindListCriteriaAssemblerInterface
{
    private const ROOT_PAGE_ID = 2;

    public function __construct(
        private FindListCriteriaAssemblerInterface $inner,
    ) {
    }

    /**
     * @param ProfileOwnerRequestInterface&RequestInterface $request
     * @return FindListCriteria
     */
    public function assemble(RequestInterface $request): FindListCriteria
    {
        $criteria = $this->inner->assemble($request);

        /** @var Filter $filter */
        $filter = $criteria->getFilter();

        if ($request->getProfile()) {
            $filter->setVisibleFor(
                (new StringListValue())
                    ->setValue(['AL', 'L'])
                    ->setStrategy(ListFilterStrategyType::IN())
            );
        } else {
            $filter->setVisibleFor(
                (new StringListValue())
                    ->setValue(['AL', 'A'])
                    ->setStrategy(ListFilterStrategyType::IN())
            );
        }

        if ($filter->getType() === null) {
            $filter->setType(
                (new StringValue())
                    ->setValue(\CDev\SimpleCMS\Model\Menu::MENU_TYPE_PRIMARY)
                    ->setStrategy(StringFilterStrategyType::EXACT())
            );
        }

        if ($filter->getParent() === null) {
            $filter->setParent(
                (new IntegerValue())
                    ->setValue(self::ROOT_PAGE_ID)
                    ->setStrategy(NumberFilterStrategyType::EXACT())
            );
        }

        $filter->setEnabled(
            (new BooleanValue())
                ->setValue(true)
                ->setStrategy(BooleanFilterStrategyType::EXACT())
        );


        /** @var OrderRule $orderRule */
        $orderRule = $criteria->getOrderRule();
        $orderRule->setPosition(OrderRuleDirection::ASC());

        return $criteria;
    }
}
