<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\SimpleCMS\API\Endpoint\Storefront\StaticPage\GetOneByCleanURL\Assembler;

use ApiPlatform\Exception\ItemNotFoundException;
use CDev\SimpleCMS\Model\Page;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Factory\Logic\Action\Storefront\StaticPage\GetOne\DTO\RequestInterface as RequestFactory;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactory $requestFactory,
        private ReadRepositoryInterface $pageRepository
    ) {
    }

    public function assemble($id): RequestInterface
    {
        /** @var Page $page */
        $page = $this->pageRepository->createQueryBuilder('entity')
            ->linkInner('entity.cleanURLs', 'cleanURL')
            ->andWhere('cleanURL.cleanURL = :cleanURL')
            ->setParameter('cleanURL', $id)
            ->getSingleResult();

        if (!$page) {
            throw new ItemNotFoundException("Page with clean_url {$id} not found");
        }

        return $this->requestFactory->create()->setId($page->getId());
    }
}
