/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(
  {
    pattern: '.input-pages-select2 select:not("#new-0-link")',
    handler: function () {
      let params = xcart.getCommentedData($(this));
      let element = $(this);
      let separator = ' / ';

      /** common object to get access to state */
      let state = {};

      let highlightSubstring = function (str = '', term) {
        let matching = str.toUpperCase().indexOf(term.toUpperCase());
        return !term || matching < 0
          ? str
          : str.substring(0, matching)
          + '<span class="highlighted">' + str.substring(matching, matching + term.length) + '</span>'
          + str.substring(matching + term.length);
      }

      let removeLastPartFromPath = function (path) {
        let parts = path.split(separator);
        parts.pop();
        return parts.join(separator);
      }

      let prepareSearchPages = function (pages) {
        let temp = {
          'categories': [{
            'id': null,
            'name': 'Category',
            'path': '',
            'type': 'path'
          }],
          'brands': [{
            'id': null,
            'name': 'Brands',
            'path': '',
            'type': 'path'
          }],
          'other': [{
            'id': null,
            'name': 'Other',
            'path': '',
            'type': 'path'
          }],
        };

        _.each(pages, function (page) {
          if (page.path.indexOf('Categories') === 0) {
            temp.categories.push(page);
          } else if (page.path.indexOf('Brands') === 0) {
            temp.brands.push(page);
          } else {
            temp.other.push(page);
          }
        });

        return [
          ...(temp.categories.length > 1 ? temp.categories : []),
          ...(temp.brands.length > 1 ? temp.brands : []),
          ...(temp.other.length > 1 ? temp.other : []),
        ];
      }

      let select2options = {
        debug: xcart.isDeveloperMode,
        language: {
          noResults: function () {
            return params['no-results-lbl'];
          },
          searching: function () {
            return '<span class="searching">' + params['searching-lbl'] + '</span>';
          },
          inputTooShort:function () {
            return params['short-lbl'];
          },
          loadingMore:function () {
            return '<span class="loading-more">' + params['more-lbl'] + '</span>';
          }
        },
        minimumInputLength: 3,
        tags: true,
        dropdownParent: element.closest('form'),
        allowClear: true,
        placeholder: params['placeholder-lbl'],
        dropdownAutoWidth: true,
        closeOnSelect: false,
        ajax: {
          url: xliteConfig.script + "?target=search_pages",
          dataType: 'json',
          delay: 250,
          data: function (params) {
            /** clear path if there is search */
            if (params.term) {
              state.path = '';
            }

            /** initial state */
            if (!Object.keys(state).length) {
              let path = $(element).data('path') ?? '';
              state.path = removeLastPartFromPath(path);
            }

            // console.log('start', state);

            return {
              path: state.path,
              search: params.term,
              page: params.page || 1
            };
          },
          processResults: function (data, params) {
            params.page = params.page || 1;
            params.mode = data.mode;
            state = {...state, ...params};

            if (state.mode === 'search') {
              data.pages = prepareSearchPages(data.pages);
            }

            // console.log('end', state);

            return {
              results: data.pages,
              pagination: {
                more: data.more
              }
            };
          },
        },
        templateResult: function (page, selectItem) {
          if (page.loading) {
            return '<span class="searching">' + params['searching-lbl'] + '</span>';
          }

          if (page.isClickable === false) {
            $(selectItem).closest('li').attr('aria-disabled', true).removeAttr('aria-selected');
          }

          // Back button
          if (page.id === 'back') {
            $(selectItem).closest('li').addClass('select2-results__option--back-button');
            return '<span class="back">' + page.name + '</span>';
          }

          // Current path button
          if (page.type === 'path') {
            let sectionName = state.mode === 'search' ? 'section' : 'current-path';
            return '<span class=' + sectionName + '>' + page.name + '</span>';
          }

          // Other buttons
          let pageName = highlightSubstring(
            xcart.utils.escapeString(page.name ?? page.text),
            xcart.utils.escapeString(state.term)
          );

          let parts = page.path ? page.path.split('/').map(function (item) {
            return xcart.utils.escapeString(item);
          }) : [];

          let quantity = page.childrenQuantity
            ? ' (' + page.childrenQuantity + ')'
            : '';

          let path = parts.length > 1 && state.mode !== 'path' && state.mode !== 'search'
            ? '<span class="path">' + removeLastPartFromPath(page.path) + ' / </span>'
            : '';

          return path + '<span class="name">' + pageName + '</span>' + quantity;
        },
        templateSelection: function (page, selectItem) {
          let path  = page.path ? page.path : page.text;
          let parts = path ? path.split(separator).map(function (item) {
            return xcart.utils.escapeString(item);
          }) : [];

          return page.name ? xcart.utils.escapeString(page.name) : parts.pop();
        }
      }

      xcart.select2.removeRedundantSelect2Blocks(element);

      /** initialize select2 */
      element.select2(select2options)
        .on("select2:select", function(e) {
          let data = e.params.data;
          data.path = data.path ?? data.text ?? data.id;

          /** item has children */
          if (data.childrenQuantity > 0 || data.id === 'back') {
            state.path = data.path;

            /** reinitialize select2 */
            element
              .empty()
              .select2(select2options)
              .select2('open');

          /** just choose item */
          } else {
            state.path = removeLastPartFromPath(data.path);
            element.select2('close');
          }
        }).on("select2:clear", function(e) {
          state.path = '';
          element.append($('<option/>').val('').prop('selected', true));
        });
    }
  }
);
