<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\Sale\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use CDev\Sale\Logic\SaleDiscount as SaleDiscountLogic;
use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        if ($input->getParticipateSale()) {
            $target->setParticipateSale(true);
            $target->setDiscountType($input->getDiscountType());
            $target->setSaleValue($input->getSalePriceValue());
            $target->setSalePrice($input->getDisplayPrice());
        } elseif ($saleDiscountPercentage = SaleDiscountLogic::getSaleDiscountPercentage($input)) {
            $target->setParticipateSale(true);
            $target->setDiscountType($input::SALE_DISCOUNT_TYPE_PERCENT);
            $target->setSaleValue($saleDiscountPercentage);
            $target->setSalePrice($input->getDisplayPrice());
        } else {
            $target->setParticipateSale(false);
        }

        return $target;
    }
}
