<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\Sale\Core;

use CDev\Sale\Model\SaleDiscount;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("CDev\Sale")
 */
class Translation extends \XLite\Core\Translation
{
    public static function getModelsToExportTranslations(): array
    {
        return array_merge(
            parent::getModelsToExportTranslations(),
            [
                SaleDiscount::class
            ]
        );
    }
}
