<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\ProductAdvisor\Logic\Action\Storefront\Product\GetList\Resolver;

use CDev\ProductAdvisor\DataSource\Product\Applier\NewArrivalsApplier;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver\FilterApplierResolverInterface;

class NewArrivalsFilterApplierResolverDecorator implements FilterApplierResolverInterface
{
    public function __construct(
        private FilterApplierResolverInterface $inner
    ) {
    }

    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        if ($property === 'newArrivals') {
            return new NewArrivalsApplier();
        }

        return $this->inner->resolve($property, $value);
    }
}
