<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\ProductAdvisor\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XLite\Core\Config;
use XLite\Core\Converter;

class NewArrivalsApplier implements ApplierInterface
{
    /**
     * @param BooleanValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $currentDate = Converter::convertTimeToUser();
        $daysOffset = abs((int) Config::getInstance()->CDev->ProductAdvisor->na_max_days)
            ?: \CDev\ProductAdvisor\Main::PA_MODULE_OPTION_DEFAULT_DAYS_OFFSET;

        if ($filterValue->getValue()) {
            $queryBuilder
                ->andWhere('entity.arrivalDate > :minDate')
                ->andWhere('entity.arrivalDate < :maxDate');
        } else {
            $orCnd = new \Doctrine\ORM\Query\Expr\Orx();
            $orCnd->add('entity.arrivalDate <= :minDate');
            $orCnd->add('entity.arrivalDate >= :maxDate');

            $queryBuilder->andWhere($orCnd);
        }

        return $queryBuilder
            ->orderBy('entity.arrivalDate', 'DESC')
            ->setParameter('minDate', ($currentDate - $daysOffset * 24 * 60 * 60))
            ->setParameter('maxDate', $currentDate);
    }
}
