<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\ProductAdvisor\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XLite\Core\Converter;

class ComingSoonApplier implements ApplierInterface
{
    /**
     * @param BooleanValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $currentDate = Converter::getDayEnd(Converter::convertTimeToUser());

        if ($filterValue->getValue()) {
            $queryBuilder->andWhere('entity.arrivalDate > :minDate');
        } else {
            $queryBuilder->andWhere('entity.arrivalDate <= :minDate');
        }

        return $queryBuilder
            ->orderBy('entity.arrivalDate', 'DESC')
            ->setParameter('minDate', $currentDate);
    }
}
