<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\Paypal\Model\Payment\Processor;

use CDev\Paypal\Core\AAPI;
use XLite\Model\Payment\Transaction;
use XLite\View\AView;

trait PaypalTransactionTrait
{
    /**
     * Get transaction message
     *
     * @param Transaction $transaction     Payment transaction (or backend transaction)
     * @param string      $transactionType Type of transaction
     *
     * @return string
     */
    public function getTransactionMessage($transaction, $transactionType)
    {
        $message = parent::getTransactionMessage($transaction, $transactionType);

        $order = $transaction->getOrder();
        $currency = $order->getCurrency();

        $transactionSums = $order->getRawPaymentTransactionSums();
        $total = $order->getTotal();

        if ($transactionType === 'capture' && $transactionSums['authorized'] !== $total) {
            $message = static::t(
                'Paypal capture warning message',
                [
                    'authorized' => AView::formatPrice($transactionSums['authorized'], $currency),
                    'total'      => AView::formatPrice($total, $currency),
                ]
            );
        }

        return $message;
    }

    /**
     * Get value for Capture transaction
     *
     * @param Transaction $transaction Transaction
     *
     * @return float
     */
    public function getCaptureTransactionValue($transaction)
    {
        return AAPI::getCaptureAmount($transaction);
    }
}
