<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Paypal\LifetimeHook\Upgrade;

use Doctrine\ORM\EntityManagerInterface;
use XLite\Model\Config;

/**
 * Change OptionName/OptionComment for paypalLoginOptions/connectWithPayPal options
 */
final class UpgradeTo551build7
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
    }

    public function onUpgrade(): void
    {
        $configRepository = $this->entityManager->getRepository(Config::class);

        /** @var Config|null $paypalLoginOptions */
        $paypalLoginOptions = $configRepository->findOneBy([
            'category' => 'CDev\Paypal',
            'name'     => 'paypalLoginOptions',
        ]);

        if ($paypalLoginOptions) {
            $paypalLoginOptions->setOptionName('Login with PayPal');
            $paypalLoginOptions->setOptionComment('<p>To enable Login with PayPal, you need to create a PayPal application for your website.</p><p><a href="https://developer.paypal.com/developer/applications">https://developer.paypal.com/developer/applications</a></p><p>The recommended procedure is to go to the “My Apps & Credentials” page and create an app for testing, then to go live with this app. Be sure to specify your "App return URL" as the value of "Redirect URL" field below.</p><p>Once the app has been created, be sure to copy your Client Id and Client Secret from the app details and credentials and have them stored in the fields below.</p>');
        }

        /** @var Config|null $connectWithPayPal */
        $connectWithPayPal = $configRepository->findOneBy([
            'category' => 'CDev\Paypal',
            'name'     => 'connectWithPayPal',
        ]);

        if ($connectWithPayPal) {
            $connectWithPayPal->setOptionName('Login with PayPal is');
        }

        if ($paypalLoginOptions || $connectWithPayPal) {
            $this->entityManager->flush();
        }
    }
}
