<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Paypal\LifetimeHook\Upgrade;

use CDev\Paypal\Main;
use XLite\Model\Payment\Method;
use XLite\Model\Payment\MethodSetting;
use XLite\Model\LanguageLabel;
use Doctrine\ORM\EntityManagerInterface;

final class UpgradeTo551build3
{
    private const DEFAULT_BN_CODE = 'XCPP4MP'; // sync with modules/CDev/Paypal/config/install.yaml

    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
    }

    public function onUpgrade(): void
    {
        $this->addBnCode();
        $this->removeLabels();

        $this->entityManager->flush();
    }

    private function addBnCode(): void
    {
        $paymentMethod = $this->entityManager->getRepository(Method::class)?->findOneBy(['service_name' => Main::PP_METHOD_PFM]);
        if (!$paymentMethod) {
            return;
        }
        $bnCodeSetting = $this->entityManager->getRepository(MethodSetting::class)?->findOneBy([
            'payment_method' => $paymentMethod,
            'name'           => 'bn_code',
        ]);

        /** @var MethodSetting $bnCodeSetting */
        if (
            $bnCodeSetting
            && !trim($bnCodeSetting->getValue())
        ) {
            $bnCodeSetting->setValue(self::DEFAULT_BN_CODE);
        }
    }

    private function removeLabels(): void
    {
        $deleteLabels = ['PayPal BN Code'];
        $labels       = $this->entityManager->getRepository(LanguageLabel::class)?->findBy(['name' => $deleteLabels]) ?: [];

        foreach ($labels as $entity) {
            $this->entityManager->remove($entity);
        }
    }
}
