<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Paypal\LifetimeHook\Upgrade;

use CDev\Paypal\Main;
use Doctrine\ORM\EntityManagerInterface;
use XLite\Core\Database;
use XLite\Model\Payment\Method;
use XLite\Model\Payment\MethodSetting;

final class UpgradeTo551build1
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {
    }

    public function onUpgrade(): void
    {
        /** @var \XLite\Model\Repo\Payment\Method $repo */
        $repo = $this->entityManager->getRepository(Method::class);

        /** @var Method[] $methods */
        $methods = $repo->createQueryBuilder('pm')
            ->where('pm.moduleName = :moduleName')
            ->andWhere('pm.service_name IN (:paymentMethods)')
            ->setParameter('moduleName', 'CDev_Paypal')
            ->setParameter('paymentMethods', [
                'PayflowLink',
                'PayflowTransparentRedirect',
                'PaypalAdvanced',
                'PaypalWPS',
                'ExpressCheckout',
                'PaypalAdaptive'
            ])
            ->getQuery()
            ->getResult();

        foreach ($methods as $method) {
            $repo->delete($method, false);
        }

        $paymentMethod = Database::getRepo(Method::class)?->findOneBy([
            'service_name' => Main::PP_METHOD_PCP
        ]);

        if ($paymentMethod) {
            $threeDSSoftExceptionSetting = Database::getRepo(MethodSetting::class)?->findOneBy([
                'payment_method' => $paymentMethod,
                'name'           => '3d_secure_soft_exception'
            ]);

            if ($threeDSSoftExceptionSetting) {
                $this->entityManager->remove($threeDSSoftExceptionSetting);
            }
        }

        $this->entityManager->flush();
    }
}
