<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Paypal\LifetimeHook\Upgrade;

use CDev\Paypal\Main;
use XLite\Core\Database;
use XLite\Model\Payment\Method;
use XLite\Model\Payment\MethodSetting;

final class UpgradeTo550build9
{
    public function onUpgrade(): void
    {
        $paymentMethod = Database::getRepo(Method::class)?->findOneBy([
            'service_name' => Main::PP_METHOD_PCP
        ]);

        if ($paymentMethod) {
            $threeDSSoftExceptionSetting = Database::getRepo(MethodSetting::class)?->findOneBy([
                'payment_method' => $paymentMethod,
                'name'           => '3d_secure_soft_exception'
            ]);

            if ($threeDSSoftExceptionSetting) {
                $entityManager = Database::getEM();

                $entityManager->remove($threeDSSoftExceptionSetting);
                $entityManager->flush();
            }
        }
    }
}
